--[[

██╗  ██╗███████╗██████╗ ██╗  ██╗ █████╗     ██╗    ██╗ █████╗ ███████╗    ██╗  ██╗███████╗██████╗ ███████╗
██║  ██║██╔════╝██╔══██╗██║  ██║██╔══██╗    ██║    ██║██╔══██╗██╔════╝    ██║  ██║██╔════╝██╔══██╗██╔════╝
███████║█████╗  ██████╔╝███████║███████║    ██║ █╗ ██║███████║███████╗    ███████║█████╗  ██████╔╝█████╗  
██╔══██║██╔══╝  ██╔═══╝ ██╔══██║██╔══██║    ██║███╗██║██╔══██║╚════██║    ██╔══██║██╔══╝  ██╔══██╗██╔══╝  
██║  ██║███████╗██║     ██║  ██║██║  ██║    ╚███╔███╔╝██║  ██║███████║    ██║  ██║███████╗██║  ██║███████╗
╚═╝  ╚═╝╚══════╝╚═╝     ╚═╝  ╚═╝╚═╝  ╚═╝     ╚══╝╚══╝ ╚═╝  ╚═╝╚══════╝    ╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝╚══════╝
                                                                                                          
    Feel free to contact me for any questions or commisions!
    https://steamcommunity.com/profiles/76561198242379576/myworkshopfiles/
    https://ko-fi.com/hepha
    Discord: hephaisto1                                                                                                          
                            
	SCP Outfit Spawn Chances that are handled through sandbox settings


require 'NPCs/ZombiesZoneDefinition'

local function InsertZombieDefinition()
	local SCPGuardSpawn = SandboxVars.SCP.SCPGuardSpawnChance;
	local SCPDClassSpawn = SandboxVars.SCP.SCPDClassSpawnChance;
	local SCPDClassSurvivorSpawn = SandboxVars.SCP.SCPDClassSurvivorSpawnChance;
	local SCPScientistSpawn = SandboxVars.SCP.SCPScientistSpawnChance;
	local SCPMTFRanger = SandboxVars.SCP.SCPMTFRangerSpawnChance;
	local SCPMTFBreacher = SandboxVars.SCP.SCPMTFBreacherSpawnChance;

	if SCPGuardSpawn > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_Guard", chance = SCPGuardSpawnChance});
	end

	if SCPDClassSpawn > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_DClass", chance = SCPDClassSpawnChance});
	end

	if SCPDClassSurvivorSpawn > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_DClass_Survivor", chance = SCPDClassSurvivorSpawnChance});
	end

	if SCPScientistSpawn > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_FoundationScientist", chance = SCPScientistSpawnChance});
	end

	if SCPMTFRanger > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_MTF_Ranger", chance = SCPMTFRangerSpawnChance});
	end

	if SCPMTFBreacher > 0.00 then
		table.insert(ZombiesZoneDefinition.Default,{name = "SCP_MTF_Breacher", chance = SCPMTFBreacherSpawnChance});
	end


end
Events.OnPostDistributionMerge.Add(InsertZombieDefinition);

]]

require 'NPCs/ZombiesZoneDefinition'

local function InsertZombieDefinition()
    local SCPGuardSpawn = SandboxVars.SCP.SCPGuardSpawnChance
    local SCPDClassSpawn = SandboxVars.SCP.SCPDClassSpawnChance
    local SCPDClassSurvivorSpawn = SandboxVars.SCP.SCPDClassSurvivorSpawnChance
    local SCPScientistSpawn = SandboxVars.SCP.SCPScientistSpawnChance
    local SCPMTFRangerSpawn = SandboxVars.SCP.SCPMTFRangerSpawnChance
    local SCPMTFBreacherSpawn = SandboxVars.SCP.SCPMTFBreacherSpawnChance

	--print("[SCP DEBUG] InsertZombieDefinition is running")
    if SCPGuardSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_Guard", chance = SCPGuardSpawn })
        --print("[SCP] Inserted SCP_Guard with chance: " .. SCPGuardSpawn)
    end

    if SCPDClassSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_DClass", chance = SCPDClassSpawn })
        --print("[SCP] Inserted SCP_DClass with chance: " .. SCPDClassSpawn)
    end

    if SCPDClassSurvivorSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_DClass_Survivor", chance = SCPDClassSurvivorSpawn })
        --print("[SCP] Inserted SCP_DClass_Survivor with chance: " .. SCPDClassSurvivorSpawn)
    end

    if SCPScientistSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_FoundationScientist", chance = SCPScientistSpawn })
        --print("[SCP] Inserted SCP_FoundationScientist with chance: " .. SCPScientistSpawn)
    end

    if SCPMTFRangerSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_MTF_Ranger", chance = SCPMTFRangerSpawn })
        --print("[SCP] Inserted SCP_MTF_Ranger with chance: " .. SCPMTFRangerSpawn)
    end

    if SCPMTFBreacherSpawn > 0.0 then
        table.insert(ZombiesZoneDefinition.Default, { name = "SCP_MTF_Breacher", chance = SCPMTFBreacherSpawn })
        --print("[SCP] Inserted SCP_MTF_Breacher with chance: " .. SCPMTFBreacherSpawn)
    end
end

-- Hook correctly depending on environment
if isServer() then
    Events.OnServerStarted.Add(InsertZombieDefinition)
else
    Events.OnPostDistributionMerge.Add(InsertZombieDefinition)
end





